package gov.va.med.mhv.calendar.service.impl;

import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

import gov.va.med.mhv.calendar.converter.AppointmentReminderConverter;
import gov.va.med.mhv.calendar.dto.AppointmentReminderDTO;
import gov.va.med.mhv.calendar.model.AppointmentReminder;
import gov.va.med.mhv.calendar.repository.AppointmentReminderRepository;
import gov.va.med.mhv.calendar.service.AppointmentReminderService;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.ResponseUtil;

public class AppointmentReminderServiceImpl implements AppointmentReminderService {
	
	private static Logger log = LogManager.getLogger(AppointmentReminderServiceImpl.class);
	
	@Autowired
	private AppointmentReminderRepository appointmentReminderRepository;

	@Override
	public List<AppointmentReminderDTO> getScheduledAppointmentRemindersForDateRange() throws MHVException {
		List<AppointmentReminderDTO> appointmentReminderDtos = null;
		List<AppointmentReminder> appointmentReminders = null;
		try {
		
			appointmentReminders = appointmentReminderRepository.getScheduledAppointmentRemindersForDateRange();
		
			appointmentReminderDtos = (null != appointmentReminders) ? new AppointmentReminderConverter().convert(appointmentReminders) : null; 
		} catch (Exception e) {
			log.error("Error in getScheduledAppointmentRemindersForDateRange" + e);
			throw new MHVException(e);
		}			
		return appointmentReminderDtos;
}
	

	@Override
	public List<AppointmentReminderDTO> getScheduledAppointmentRemindersForPatient(Long patientId) throws MHVException {
		List<AppointmentReminderDTO> appointmentReminderDtos = null;
		List<AppointmentReminder> appointmentReminders = null;
		try {
		
			appointmentReminders = appointmentReminderRepository.getScheduledAppointmentRemindersForPatient(patientId);
		
			appointmentReminderDtos = (null != appointmentReminders) ? new AppointmentReminderConverter().convert(appointmentReminders) : null; 
		} catch (Exception e) {
			log.error("Error in getScheduledAppointmentRemindersForPatient" + e);
			throw new MHVException(e);
		}			
		return appointmentReminderDtos;
	}

	@Override
	public void saveAppointmentReminder(AppointmentReminderDTO appointmentReminderDto) throws MHVException {
	ResponseUtil <AppointmentReminderDTO> response = new ResponseUtil <AppointmentReminderDTO>();
		
	AppointmentReminder appointmentReminder= null;
		
		try {
		
			response.setFailure(true);
			
			if (response.isFailure()) {
				log.error(response.getFailureMessage());
				throw new MHVException(response);
			}
			
			appointmentReminder = new AppointmentReminderConverter().convert(appointmentReminderDto);
			appointmentReminder = appointmentReminderRepository.save(appointmentReminder);
			
			if (log.isDebugEnabled()) {
				log.debug("SAVE saveAppointmentReminder completed successful...");
			}
			
		} catch (MHVException ex) {
			throw ex;
		} catch(Exception e) {
			String message = "Exception Caught saveAppointmentReminder";
			log.error(message, e);
			e.printStackTrace();
			throw new MHVException(message, e);
		}
		

	}

	@Override
	public void deleteAppointmentReminder(Long id) throws MHVException {
	ResponseUtil <Long> response = new ResponseUtil <Long>();
		
		try {
			appointmentReminderRepository.delete(id);
		} catch(Exception e) {
			String message = "Exception Caught deleteAppointmentReminder";
			log.error(message, e);
			e.printStackTrace();
			throw new MHVException(message, e);
		}

	}

}
